CWIDTH=42
TOPC = 300-CWIDTH/2
BOTC = 300+CWIDTH/2
w = walls([(0,0), (200, 0), 'in1', (252, 0), (800, 0), (800, TOPC), 'out1',
           (800, BOTC), (800, 600), (0, 600)], texture='enemywall',
          bg=('bugbg', -1, -1),
          closed=True)
#image(w, image="level5-organship", offset=(-150, -150))

ppack, p = package(payload=Player(), rel=('top', w),
                   pos=(2000, 2000),
                   pattern=[((10, 0), 120)], texture="humanboxwall", bg="humanboxbg")


room2 = walls([(-200, TOPC), (0, TOPC), (0, 0), (800, 0), (800, 600), (600, 600),
               'heartspace', (200, 600),
               (0, 600),
               (0, BOTC), (-200, BOTC)], rel=('right', w), pos=(0, 0), texture="enemywall",
              bg=("bugbg-heartroom", -1, -1))
image(room2, offset=(-200, TOPC), image="corridor")

circle(20, pos=(600, 300), rel=room2, image="level5-anchor", static=True)
circle(20, pos=(200, 300), rel=room2, image="level5-anchor", static=True)

heartroom = walls([(700, 600), (700, 800), (100, 800), (100, 600)], rel=room2,
                  texture='enemywall', bg=("heartbg", 99, 599))

c2 = box((240, 30), pos=(350, 585), static=True, image="cpanel", outanim="cpdeath", health=600, remains=True)

rightpat = [((5, 0), 40), ((0, 0), 0), ((-5, 0), 40), ((0, 0), 0), Repeat]
leftpat = mirror_x(rightpat)
#rightpat[2:2] = ['if get_flag("bigedie") == 1: print "stop"; stop(bige.diesound)', 'if get_flag("bigedie"): set_flag("bigedie", 1)']
leftw = walls([(0, 200), 'w', (0, 0), (-200, 0)], pattern=rightpat, rel=room2, pos=(200, 600), static=True, texture="enemywall")
chain(room2, leftw, (100, 700), (-100, 100), texture="heartpiston")
image(leftw, 'w', 'left', image='heartwall', layer=LAYERGEOMS)

bige = enemy(ai=ai.Wanders(speed=0.5),
          shapes=[Circle(24, image="boss1", density=9)], pos=(100, 300), rel=room2,
          size=8, health=None, attackimg='boss1-attack', bulletimage='bossbullet',
             diesound="bossdie2.ogg", on_destroy=['set_flag("bigedie", True)'])

rightw = walls([(200, 0), (0, 0), 'w', (0, 200)], pattern=leftpat, rel=room2, pos=(600, 600), static=True, texture="enemywall")
chain(rightw, room2, (100, 100), (700, 700), texture="heartpiston")
image(rightw, 'w', 'right', image='heartwall', fliph=True, layer=LAYERGEOMS)
chain(room2, room2, (400, 0), (400, 600), texture='pumpingblood', rot=270, start=42)
##bloods=[]
##for y in range(0, 600, 70):
##    bloods.append(image(room2, image='pumpingblood', offset=(375, y), start=42))

dialog("OK, Cadet, we only have a few more things to cover, and then -- ", characters.Sargeant)

music('panic.ogg')

start(p, [((4, 8), 10)])
# Flash the screen red?
dialog("What was that??", characters.Sargeant)
#seconds(10)
down = [((0, 10), 100), Repeat]
start(ppack, down)

dialog("Sorry Cadet, there's been a change of plans. I'm sorry to have to do this to you, but we've had a bit of a crisis.", characters.Sargeant)
dialog("We've been attacked. We need you to take out the attackers. Think of this as a live-fire exercise.", characters.Sargeant)
d = align(ppack, 'top', w, (200, -1000))
move_by(p, d)
down = [((0, 10), 100), ((0, 0), 0), 'set_flag("landed", True)']
start(p, down)
start(ppack, down)

delete(room2, 'heartspace')
flag('landed')
fx('bg', 'invert')
elocs1 = [(220, 60), (100, 200), (600, 125), (400, 300), (175, 400), (325, 550),
          (675, 450)]
room1es = []
for i in range(7):
    py = 150+45*i
    pattern = [((0, 0), 10 + 5*i), ((3, 0), 10), 'delete(self)', 'place(room1es[%d])'%i]
    c = circle(14, static=True, pos=(-7.5, py), pattern=pattern, image='invertebrate-bg')
    new = Enemy(ai=ai.DoesAll(ai.Wanders(speed=4), ai.Targets(period=80, strength=10)),
                shapes=[Circle(12, density=5, image='invertebrate',
                               inanim='invertebrate-in')],
                pos=(30-7.5, py), rel=w, size=12, health=100,
                bulletexplodeimage="invertebrate-bullethit",
                bulletimage='invertebrate-bullet',
                outanim="invertebrate-%(killer)sdeath")
    room1es.append(new)

#c1 = box((20, 200), pos=(10, 450), static=True, health=600)
dialog('OK Tiger, go get \'em!', characters.Sargeant)

door(w, 'in1').open()
delete(ppack, 'bottom')

ticks(51)
all(map(Kills, room1es))
all(map(Kills, [c2]), meanwhile=Sequence(
    Dialog("Great, good job. Now you're going to need to break in to their fore wing and destroy their captain.", characters.Sargeant),
    Dialog("Our boys in Engineering can broadcast a pirate signal if you destroy their control boards.", characters.Sargeant)))

dialog("Transmitting signal, Commander!", characters.Engineer)
seconds(1)
door(w, 'out1', image='').open()
room2es = []
elocs2 = [(150, 200), (750, 400)]
for pos in elocs2:
    new = enemy(ai=ai.DoesAll(ai.Wanders(speed=4), ai.Targets(period=80, strength=10)),
                shapes=[Circle(12, density=5, image='invertebrate')], pos=pos,
                rel=room2, size=12, health=100, bulletexplodeimage="invertebrate-bullethit", bulletimage='invertebrate-bullet',
                outanim="invertebrate-%(killer)sdeath")
    room2es.append(new)


bige.ai = ai.DoesAll(bige.ai, ai.Targets(period=300, strength=30))
kills(bige,meanwhile=Sequence(
    Dialog("Be careful, Cadet! Your bullets won't penetrate the captain's shield.", characters.Sargeant),
    Dialog("You need to find another way to destroy him.", characters.Sargeant)))
d = Dialog("Missile stations! Fire at will!", characters.Sargeant)
fx('bg', 'invert')
seconds(2, meanwhile = d)
s = play("deepboom.ogg", -1)
for j in range(180):
    ticks(1, meanwhile=d)
    x = randint(0, 1600)
    y = randint(0, 600)
    image(w, offset=(x, y), image="bigexplosion", repeat=False)

s.fadeout(2000)
fx('over', 'fade', color = (255, 255, 255), ticks = 30)
ticks(30)
s = fx('ship-oblique', 'rotozoom',  rotrate=.75, startpt=(400, 300, 1.0), velocity=(-3, -2, -.01))
fx(s, 'fade', reverse=True, color=(255, 255, 255), ticks=30)
d = Dialog("Report back to base right away. Your assistance is needed repairing the station. We'll debrief you afterwards.", characters.Sargeant)
ticks(90, meanwhile=d)
s.kill()
wait(d)
