music('deepsparse.ogg')
box1=walls([(450, 500), (700, 500), (700, 0), (350+26, 0), 'box1in',
            (350-26, 0), (0, 0), (0, 500), (250, 500)],
           pos=(0, 900), counter=True, closed=False, texture="humanwall",
           bg=("level4-room1", -1, -1),
           corners_at=[(-1, 'end', ('invertcorner', 90)),
                       (0, 'start', ('invertcorner', 180))])
b1idoor = door(box1, 'box1in')
startpattern = [((0, 10), 90), ((0, 0), -1), 'delete(self,"bottom")',
                'b1idoor.open()']
p = Player(pos=(100, 100))
startbox = package(payload=p, pattern=startpattern,
                   rel=('top', box1), pos=(350-26, -900), texture="humanboxwall", bg='humanboxbg')
circle(20, pos=(350, 1150), static=True, image="anchor")
box1p2 = walls([(450, 500), 'box1out', (250, 500)], texture="humandoublewall",
               startcorner=False, rel=box1, start='humandoublewall-end')
b1odoor = door(box1p2, 'box1out', texturebg='humanwall-opendoor')
s = switch(shapes=[Circle(8, image="human-button")], pos=(250, 1400), action=['b1odoor.open()', 'set_flag("switch1", True)'], angle=90)

crushbox = walls([(600, 0), 'indoor', (400, 0), (0,0), (0, 400), (400, 400)], counter=True, rel=('bottom', box1), pos=(-150, 0), texture='humanwall', bg=('level4-room2', -2, -1), corners_at=[(-2, 'end', ('invertcorner', 270))])
door(crushbox, 'indoor').open()
crushargs = {'rel':crushbox, 'texture':'humanwall'}

crushrighttopwall = walls((600, -THICKNESS), (600, 200-THICKNESS),
                          rel=crushbox, texture="humanwall")
crushrightinswall = walls((600, 200), (200, 200), rel=crushbox,
                          texture="humandoublewall", startcorner=False)
crushinsidewall = walls((600, 200+THICKNESS), (600, 600),
                        rel=crushbox, texture="humandoublewall",
                        startcorner='humandoublewall-corner')
# We'll open this door later
crushopendoor = walls((600, 600), 'door', (600, 800), rel=crushbox,
                      texture='humanwall')

downpat = [((0, 5), 40), ((0, 0), 0), ((0, -5), 40), ((0, 0), 0), Repeat]
uppat = mirror_y(downpat)

topcrush = walls([(0, 0), (200, 0)], pattern=downpat, rel=crushbox, texture='humandoublewall', start='humandoublewall-end', startcorner=False)
botcrush = walls([(0, 400), (200, 400)], counter=True, pattern=uppat, rel=crushbox, texture='humandoublewall', start='humandoublewall-end', startcorner=False)

tunnelargs = {'rel':topcrush, 'pos':(400, 400), 'texture':'humanwall',
              'corners_at': [(-1, 'end', ('invertcorner', 180))]}
#tunnelright = walls([(200, 0), (200, 200)], **tunnelargs)
tunnelleft = walls([(200, 400), (0, 400), (0, 0)], bg='level4-hall', **tunnelargs)

room2 = walls([(0, 0), (800, 0), (800, 600), 'room2out', (700, 600),
               (0, 600)],
              rel=[('right', tunnelleft), ('bottom', tunnelleft, 'bottom')],
              pos=(0, 0), texture='humanwall', bg=('trainingbg2', -1, -1), start=("humanwall-invertcorner", 0))
door(crushopendoor, 'door').open()
e1ai = ai.Leads(period=40, turnrate=1, strength=40)
e1 = enemy(ai=ai.Stationary(),
          shapes=[Circle(8, image="drone")], pos=(28, 300), rel=room2,
          size=8, health=None, static=True, angle=270)

shelter = walls([(200, 300), (200, 200), (300, 200), (300, 300)],
                rel=room2, texture='humandoublewall', start='humandoublewall-end', startcorner=False)

shelter2 = walls([(520, 600), (520, 400)], rel=room2, texture="humandoublewall")


room3 = walls([(100, 0), (100, 100), (0, 100), (0, 400), (300, 400),
               (300, 100), (200, 100), (200, 0)],
              rel=room2, pos=(600, 600), counter=True, texture='humanwall',
              bg=("level4-bottle", -1, -1),
              corners_at=[(-1, 'end', ('invertcorner', 180))])
r2odoor = door(room2, 'room2out', texture='humandoublewall', start='humandoublewall-end', startrot = 0)
s2 = switch(shapes=[Circle(8, image="human-button")], pos=(800, 400), rel=room2, action=['r2odoor.open()'], angle=180)

e2dist = 600-24
e2ai=ai.Shoots()
e2 = enemy(ai=ai.Stationary(), shapes=[Circle(8, image="drone")], pos=(500, 12),
           rel=room2, angle=180, static=True, health=None,
           pattern=[((0, e2dist/72), 72), ((0, -e2dist/72), 72), Repeat])

dialog("One more thing you might like to know about is the pull beam.", characters.Sargeant)
dialog("The pull beam is like a rope made of pure energy, totally unbreakable. This room is for you to play with it and get used to it.", characters.Sargeant)
dialog("To use the pull beam, shoot with the S key.")
dialog("To unhook it, press S again.")
dialog("There's a switch on the south wall. Hit it when you're ready to move on.", characters.Sargeant)
flag('switch1')
ds = Sequence(Dialog("Getting past this crusher is tough, but the pull beam should help.", characters.Sargeant))
objectin(p, (0, 0, 200, 400), rel=tunnelleft, meanwhile=ds)
e1.ai = e1ai
e2.ai = e2ai

objectin(p, (0, 100, 300, 300), rel=room3, meanwhile=Sequence(
    Dialog("Now just zip through this last room.", characters.Sargeant)))
    
dialog("Nice going. Before long you may be a real pilot!", characters.Sargeant)
