music('deepsparse.ogg')
w = walls([(0, 0), (0, 600), (800, 600), (800, 536), 'edoor1', (800, 500), (800, 0), (400, 0), 'edoor2', (300, 0)], counter=True, closed=True, texture="humanwall", bg=('trainingbg', -1, -1))
p = player(pos=(250+400, 100+12-16), velo=(0, 0))
e = Enemy(ai=ai.Shoots(), angle=90, shapes=[Circle(8, image="drone")], pattern=[((-3, 0), 30)], size=8, health=20)

d1 = door(w, 'edoor1')
d2 = door(w, 'edoor2')
box, e = enemybox(payload=e, pos=(20, 500), side='right', target=w, targetcut='d1', texture='humanboxwall', bg='humanboxbg')

kills(e,
      meanwhile=Sequence(
    Dialog("OK, Cadet, we've made things a little bit more interesting by throwing a drone in there with you. He's not very bright, but he provides a simulated challenge.", characters.Sargeant),
    Dialog("Shoot him down. It shouldn't be hard.", characters.Sargeant),
    Dialog("Press 'A' to shoot.")))

dialog("Not bad.", characters.Sargeant)
p.health = 10
dialog("Of course, anyone can win if they have superior strength. I'm reducing your armor a bit.", characters.Sargeant)
epattern = [((0, 5), 100), ((0, 0), -1)]
w2 = walls([(250, 400), (400, 400), (400, 0), (0, 0), (0, 400), (150, 400)], counter=True, rel=('top', w), pos=(150, -500), pattern=epattern+['d2.open()'], texture='humanboxwall', texturebg="humanboxbg")
positions = [((400-9, 400-16), 180), ((9, 400-16), 0), ((9, 200), 315), \
             ((400-9, 200), 225)]
enemies = []
for pos, a in positions:
    e = enemy(ai=ai.Shoots(), shapes=[Circle(8, image="drone")], rel=w2, pos=pos, angle=a,
              pattern=epattern)
    enemies.append(e)

done = False
dlgs = [Dialog("See if you can blow your way through this box.", characters.Sargeant), Dialog("It's tough, isn't it? Try using some fancy maneuvering.", characters.Sargeant), NoneEvent()]
n = 0
while not done:
    try:
        all(meanwhile=dlgs[n], *map(Kills, enemies))
    except GameOver:
        a = p.angle
        delete(p)
        p = player(pos=(600, 500), velo=(0, 0), health=10, angle=a)
        if n+1 < len(dlgs): n += 1
    else:
        done=True

dialog("Well done.", characters.Sargeant)
dialog("Let's move to the next mission, intelligent adversaries.", characters.Sargeant)
    
